

 /***************************************************************************************************************
  *                                                                                                             *
  *                        Example_2. ET-REMOTE MP3 Trig-Mode By Check EOF Signal                               *
  *                                                                                                             *
  ***************************************************************************************************************
  *												                                                                *
  * Target MCU     : AT89C51RE2 (CP-JR51RE2 V1.0)                                                               *
  * Editor         :  uvision3 3.62c                                                                            *       
  * Compiler       : Keil C51 (V8.05 a)                                                                         *
  *															                                                    *
  * Port Interface :                                                                                            *
  *																											    *
  *            I/O : # MCU-89C51RE2 #            # ET-MINI 3TO5TTL #                     # ET-REMOTE MP3 #      *
  *                  ----------------           ----------------------                   -----------------      *
  *                                                                                                             *                                   
  *                  P1[0..7](OUT)   connect   IN0-IN7(#1)<--> OUT0-OUT7(#1)  connect     Trig CH1-CH8          *                                        
  *                  P2[0..7](OUT)   connect   IN0-IN7(#2)<--> OUT0-OUT7(#2)  connect     Trig CH9-CH16         *
  *                  P0.0(IN)        ---------------------------------------  connect     EOF Terminal          *                            
  *                  +5V             connect   +VIN (#1,#2)<--> +VOUT(#1,#2)  connect     +3.3V                 *
  *                  GND             connect   GND  (#1,#2)<--> GND  (#1,#2)  connect     GND                   *                                                                 *
  *                                                                                                    		    *
  * 																									        *
  *                                                                                  DIP-SW.MODE      		    *
  *           5V                                                                      S1=OFF,S2=OFF             *
  *         --+--                                            +------------------+    DIF SW.CONFIG              *
  *           |                                              |                  |     S1=OFF,S2=ON              *
  *           +----------+                                   |          --------+-----------                    *
  *           |          |      -----------------------      |         |     +VOUT3V3       |                   *
  *     ------+-----     +-----|+VIN              +VOUT|-----+    Trig |                    |                   *
  *    |        P1.0|----|-----|IN0                OUT0|-----|---------|CH1                 |                   *
  *    |         .  |    |     | .                  .  |     |         | .                  |                   *
  *    |         .  |    |     | .   ET-MINI3TO5#1  .  |     |         | .                  |                   *
  *    |         .  |    |     | .                  .  |     |         | .                  |                   *
  *    |        P1.7|----|-----|IN7                OUT7|-----|---------|CH8                 |                   *
  *    |            |    |  +--|G                    G |--+  |         |                    |                   *
  *    |            |    |  |  +-----------------------+  |  |         |   ET-REMOTE MP3V2  |                   *
  *    |            |    +--|--|+VIN              +VOUT|--|--+    Trig |                    |                   *
  *    |        P2.0|-------|--|IN0                OUT0|--|------------|CH9                 |                   *
  *    |         .  |       |  | .                  .  |  |            | .                  |                   *
  *    |         .  |       |  | .   ET-MINI3TO5#2  .  |  |            | .               EOF|---+               *
  *    |         .  |       |  | .                  .  |  |            | .                  |   |               *
  * +--|P0.0    P2.7|-------|--|IN7                OUT7|--|------------|CH16   [Supply]     |   |               *
  * |   -----+------        +--|G                    G |--+            |       G    5V      |   |               *
  * |        |89C51RE2      |   -----------------------   |             -------+-----+------    |               *
  * |      --+--            |                             |                    |     |          |               *
  * |       ---             +-----------------------------+--------------------+     |          |               *
  * |        -              |                                                  |     +-->5V     |               *
  * |                     --+--                                              --+--              |               *
  * |                      ---                                                ---               |               *
  * |                       -                                                  -                |               *
  * |                                                                                           |               *
  * +-------------------------------------------------------------------------------------------+               *
  *																											    *
  * Operation       : Play File 1-16 By Trig Auto                                                               *
  * Last Update     : 5/June/2012                                                                               *   
  * Create By       : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                                                      *
  *                                                                                                             * 
  ***************************************************************************************************************/ 
						
#include <at89c51xd2.h>
#include <stdio.h>

 unsigned int counter ;

/****************************************************************
 *       Interrupt Service Timer0 (Interrupt every 1 ms) 	    *
 ****************************************************************/

 void TM0_Mod1() interrupt 1
 {
 
  TF0     = 0         ; //Clear int. flag 
  TH0     = 0xF4      ; //Up date 16bit Reload Timer0
  TL0     = 0x00      ; //0xF400 = 1 ms 

  counter = counter+1 ; //Counter for Cursor blink

 }

/***************************************************
 *                   Function delay ms 			   *
 ***************************************************/

void delay_ms(unsigned int cnt)
 {
   TR0 = 1        ;	//Enable Timer0 INT.
   ET0 = 1        ;	//Set TCON Register ON Timer0
   counter = 0    ; //Clear Counter

   while(counter<cnt){;}

   TR0 = 0       ;  //Set TCON Reg. Off Timer0
   ET0 = 0       ;	//Disable Timer0 Interrupt

 }

/****************************************************
 *           Initial Timer0 Control for delay       *
 ****************************************************/

 void Timer0_Init(void)
  {
   TH0   = 0xF4   ;	//Start Interrupt every 1 ms
   TL0   = 0x00   ;
  	 
   TMOD |= 0x01   ; //Use Timer0 Mode1 16-bit																							    
   ET0   = 0	  ; //Disable Timer0 Interrupt 
   TR0   = 0      ; //Set TCON Reg. Off Timer0
  }

/*****************************************
 **        Function Initial Port        **
 *****************************************/

 void Init_Port(void)
  {
    //--- Set default output Port = 1  ----

   	 P1 = 0xFF  ;  
	 P2 = 0xFF  ;
	 P0_0 = 1   ;   //Input
  }


 
/************************************************************************
 *               Check Status Signal EOF : End OF File 				    *
 ************************************************************************/

void Chk_Eof()
{
  char eof                 ;
       
  do                            //Loop Check Eof = 0 :end file 
   {
     eof  = P0_0              ; //Read P0.0 : 0 = end of message , 1 = Ready for Play or Playing  
     eof  = eof & 0x01        ; //Mark bit 0
   }while(eof == 1)           ; //eof = 0 exit loop
    
  do                            //Loop Check Eof = 1 : Ready 
   {
     eof  = P0_0              ; //Read P0.0 : 0 = end of message , 1 = Ready for Play or Playing  
     eof  = eof & 0x01        ; //Mark bit 0
   }while(eof == 0)           ; //eof = 1 exit loop
}



 /************************************************************
  **                                                        **
  **      Function Play File CH1-CH16(Trig Active 0)        **
  **                                                        **
  ************************************************************/ 


void Play_File(void)
{
  
  char bt,bi=0xFE,del=0x01  ;

    //--------------- P1[0..7] TRIG CH[1..8]-------------

  for(bt=0;bt<8;bt++)      //Loop Control Port bit for Trig Next File
   {                    
     P1  = bi           ;    //P1_Bit(x)=0 : Trig-CH(x+1)   
     delay_ms(20)       ;    //Delay 20 ms for Trig 0
     P1 = 0xFF          ;    //P1_Bit(All)=1  
     Chk_Eof()          ;    //Check Play End File
     bi = bi-del        ;    //Mark bit x = 0 (x=0-7)
     del= del << 1      ;    //Value for use Mark bit 
  
   }

    //--------------- P2[0..7] TRIG CH[9..16]-------------

  bi  = 0xFE            ;    //Initial Start Mark bit0 =0
  del = 0x01            ;    //Initial value mark bit =1

  for(bt=0;bt<8;bt++)        //Loop Control Port bit for Trig Next File
   {                   
     P2 = bi            ;    //P2_Bit(x)=0 : Trig-CH(x+9)   
     delay_ms(20)       ;    //Delay 20 ms for Trig 0
     P2 = 0xFF          ;    //P2_Bit(All)=1  
     Chk_Eof()          ;    //Check Play End File
	 bi = bi-del        ;    //Mark bit x = 0 (x=0-7)
     del= del << 1      ;    //Value for use Mark bit 
         
   }

}


/**********************************************************************
 **                                                                  **
 **                         main Program                             **
 **                                                                  **
 **********************************************************************/
 
 void main(void) 
 {
    CKCON0 = 0x01     ;  // div 6 clk mode  X2=1
    AUXR   = 0x10     ;  //Set XRAM = 1792 Byte

    Init_Port()       ;
    Timer0_Init()     ;

    EA   = 1          ;  //Enable global Interrupt  

    delay_ms(3000)    ;  //delay for Sync Borad MP3 Ready 

    while(1)
    {
     delay_ms(3000)  ;
     Play_File()     ;   //Sen Signal Trig Start Play File CH1
    }   

 
}
















